/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import sun.awt.AWTAccessor;

public class FileDialog
extends Dialog {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    int mode;
    String dir;
    String file;
    private File[] files;
    private boolean multipleMode = false;
    FilenameFilter filter;
    private static final String base = "filedlg";
    private static int nameCounter = 0;
    private static final long serialVersionUID = 5035145889651310422L;

    private static native void initIDs();

    public FileDialog(Frame frame) {
        this(frame, "", 0);
    }

    public FileDialog(Frame frame, String string) {
        this(frame, string, 0);
    }

    public FileDialog(Frame frame, String string, int n) {
        super(frame, string, true);
        this.setMode(n);
        this.setLayout(null);
    }

    public FileDialog(Dialog dialog) {
        this(dialog, "", 0);
    }

    public FileDialog(Dialog dialog, String string) {
        this(dialog, string, 0);
    }

    public FileDialog(Dialog dialog, String string, int n) {
        super(dialog, string, true);
        this.setMode(n);
        this.setLayout(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<FileDialog> clazz = FileDialog.class;
        synchronized (FileDialog.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && this.parent.getPeer() == null) {
                this.parent.addNotify();
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createFileDialog(this);
            }
            super.addNotify();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.mode = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal file dialog mode");
            }
        }
    }

    public String getDirectory() {
        return this.dir;
    }

    public void setDirectory(String string) {
        this.dir = string != null && string.equals("") ? null : string;
        FileDialogPeer fileDialogPeer = (FileDialogPeer)this.peer;
        if (fileDialogPeer != null) {
            fileDialogPeer.setDirectory(this.dir);
        }
    }

    public String getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getFiles() {
        Object object = this.getObjectLock();
        synchronized (object) {
            if (this.files != null) {
                return (File[])this.files.clone();
            }
            return new File[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFiles(File[] fileArray) {
        Object object = this.getObjectLock();
        synchronized (object) {
            this.files = fileArray;
        }
    }

    public void setFile(String string) {
        this.file = string != null && string.equals("") ? null : string;
        FileDialogPeer fileDialogPeer = (FileDialogPeer)this.peer;
        if (fileDialogPeer != null) {
            fileDialogPeer.setFile(this.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMultipleMode(boolean bl) {
        Object object = this.getObjectLock();
        synchronized (object) {
            this.multipleMode = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMultipleMode() {
        Object object = this.getObjectLock();
        synchronized (object) {
            return this.multipleMode;
        }
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public synchronized void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
        FileDialogPeer fileDialogPeer = (FileDialogPeer)this.peer;
        if (fileDialogPeer != null) {
            fileDialogPeer.setFilenameFilter(filenameFilter);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.dir != null && this.dir.equals("")) {
            this.dir = null;
        }
        if (this.file != null && this.file.equals("")) {
            this.file = null;
        }
    }

    @Override
    protected String paramString() {
        String string = super.paramString();
        string = string + ",dir= " + this.dir;
        string = string + ",file= " + this.file;
        return string + (this.mode == 0 ? ",load" : ",save");
    }

    @Override
    boolean postsOldMouseEvents() {
        return false;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            FileDialog.initIDs();
        }
        AWTAccessor.setFileDialogAccessor(new AWTAccessor.FileDialogAccessor(){

            @Override
            public void setFiles(FileDialog fileDialog, File[] fileArray) {
                fileDialog.setFiles(fileArray);
            }

            @Override
            public void setFile(FileDialog fileDialog, String string) {
                fileDialog.file = "".equals(string) ? null : string;
            }

            @Override
            public void setDirectory(FileDialog fileDialog, String string) {
                fileDialog.dir = "".equals(string) ? null : string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMultipleMode(FileDialog fileDialog) {
                Object object = fileDialog.getObjectLock();
                synchronized (object) {
                    return fileDialog.multipleMode;
                }
            }
        });
    }
}

