/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.uploaders;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Uploader;
import java.io.File;
import java.util.List;
import processing.app.BaseNoGui;
import processing.app.PreferencesData;
import processing.app.debug.RunnerException;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.StringReplacer;

public class GenericNetworkUploader
extends Uploader {
    private final BoardPort port;

    public GenericNetworkUploader(BoardPort port) {
        this.port = port;
    }

    @Override
    public boolean requiresAuthorization() {
        return ((String)this.port.getPrefs().get("auth_upload")).contentEquals("yes");
    }

    @Override
    public String getAuthorizationKey() {
        return "runtime.pwd." + this.port.getAddress();
    }

    @Override
    public boolean uploadUsingPreferences(File sourcePath, String buildPath, String className, boolean usingProgrammer, List<String> warningsAccumulator) throws Exception {
        boolean uploadResult;
        String tool;
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        PreferencesMap prefs = PreferencesData.getMap();
        PreferencesMap boardPreferences = BaseNoGui.getBoardPreferences();
        if (boardPreferences != null) {
            prefs.putAll(boardPreferences);
        }
        if ((tool = prefs.getOrExcept("upload.tool")).contains(":")) {
            String[] split = tool.split(":", 2);
            targetPlatform = BaseNoGui.getCurrentTargetPlatformFromPackage(split[0]);
            tool = split[1];
        }
        prefs.putAll(targetPlatform.getTool(tool));
        String password = "";
        if (this.requiresAuthorization()) {
            password = prefs.getOrExcept(this.getAuthorizationKey());
        }
        prefs.put("network.password", password);
        prefs.put("network.port", this.port.getPrefs().get("port"));
        prefs.put("build.path", buildPath);
        prefs.put("build.project_name", className);
        if (this.verbose) {
            prefs.put("upload.verbose", prefs.getOrExcept("upload.params.verbose"));
        } else {
            prefs.put("upload.verbose", prefs.getOrExcept("upload.params.quiet"));
        }
        try {
            String pattern = (String)prefs.get("upload.network_pattern");
            if (pattern == null) {
                pattern = prefs.getOrExcept("upload.pattern");
            }
            String[] cmd = StringReplacer.formatAndSplit(pattern, prefs, true);
            uploadResult = this.executeUploadCommand(cmd);
        }
        catch (RunnerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
        return uploadResult;
    }

    @Override
    public boolean burnBootloader() throws RunnerException {
        throw new RunnerException("Burning bootloader is not supported via network!");
    }
}

