/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.filter;

import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.FilterAsAlphaRable;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.MultiplyAlphaRed;
import org.apache.batik.ext.awt.image.rendered.RenderedImageCachableRed;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.filter.Mask;

public class MaskRable8Bit
extends AbstractRable
implements Mask {
    protected GraphicsNode mask;
    protected Rectangle2D filterRegion;

    public MaskRable8Bit(Filter filter, GraphicsNode graphicsNode, Rectangle2D rectangle2D) {
        super(filter, null);
        this.setMaskNode(graphicsNode);
        this.setFilterRegion(rectangle2D);
    }

    @Override
    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    @Override
    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    @Override
    public Rectangle2D getFilterRegion() {
        return (Rectangle2D)this.filterRegion.clone();
    }

    @Override
    public void setFilterRegion(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException();
        }
        this.filterRegion = rectangle2D;
    }

    @Override
    public void setMaskNode(GraphicsNode graphicsNode) {
        this.touch();
        this.mask = graphicsNode;
    }

    @Override
    public GraphicsNode getMaskNode() {
        return this.mask;
    }

    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.filterRegion.clone();
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Filter filter = this.getMaskNode().getGraphicsNodeRable(true);
        PadRable8Bit padRable8Bit = new PadRable8Bit(filter, this.getBounds2D(), PadMode.ZERO_PAD);
        RenderedImage renderedImage = (filter = new FilterAsAlphaRable((Filter)padRable8Bit)).createRendering(renderContext);
        if (renderedImage == null) {
            return null;
        }
        CachableRed cachableRed = RenderedImageCachableRed.wrap((RenderedImage)renderedImage);
        PadRable8Bit padRable8Bit2 = new PadRable8Bit(this.getSource(), this.getBounds2D(), PadMode.ZERO_PAD);
        renderedImage = padRable8Bit2.createRendering(renderContext);
        if (renderedImage == null) {
            return null;
        }
        CachableRed cachableRed2 = GraphicsUtil.wrap((RenderedImage)renderedImage);
        cachableRed2 = GraphicsUtil.convertToLsRGB((CachableRed)cachableRed2);
        MultiplyAlphaRed multiplyAlphaRed = new MultiplyAlphaRed(cachableRed2, cachableRed);
        return multiplyAlphaRed;
    }
}

