/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;
import processing.app.AbstractMonitor;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.TextAreaFIFO;
import processing.app.Theme;

public abstract class AbstractTextMonitor
extends AbstractMonitor {
    protected JLabel noLineEndingAlert;
    protected TextAreaFIFO textArea;
    protected JScrollPane scrollPane;
    protected JTextField textField;
    protected JButton sendButton;
    protected JButton clearButton;
    protected JCheckBox autoscrollBox;
    protected JComboBox lineEndings;
    protected JComboBox serialRates;

    public AbstractTextMonitor(BoardPort boardPort) {
        super(boardPort);
    }

    @Override
    protected void onCreateWindow(Container mainPane) {
        Font consoleFont = Theme.getFont("console.font");
        Font editorFont = PreferencesData.getFont((String)"editor.font");
        Font font = Theme.scale(new Font(consoleFont.getName(), consoleFont.getStyle(), editorFont.getSize()));
        mainPane.setLayout(new BorderLayout());
        this.textArea = new TextAreaFIFO(8000000);
        this.textArea.setRows(16);
        this.textArea.setColumns(40);
        this.textArea.setEditable(false);
        this.textArea.setFont(font);
        ((DefaultCaret)this.textArea.getCaret()).setUpdatePolicy(1);
        this.scrollPane = new JScrollPane(this.textArea);
        mainPane.add((Component)this.scrollPane, "Center");
        JPanel upperPane = new JPanel();
        upperPane.setLayout(new BoxLayout(upperPane, 0));
        upperPane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.textField = new JTextField(40);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                AbstractTextMonitor.this.textField.requestFocusInWindow();
            }
        });
        this.sendButton = new JButton(I18n.tr((String)"Send"));
        this.clearButton = new JButton(I18n.tr((String)"Clear output"));
        upperPane.add(this.textField);
        upperPane.add(Box.createRigidArea(new Dimension(4, 0)));
        upperPane.add(this.sendButton);
        mainPane.add((Component)upperPane, "North");
        final JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.autoscrollBox = new JCheckBox(I18n.tr((String)"Autoscroll"), true);
        this.noLineEndingAlert = new JLabel(I18n.format((String)I18n.tr((String)"You've pressed {0} but nothing was sent. Should you select a line ending?"), (Object[])new Object[]{I18n.tr((String)"Send")}));
        this.noLineEndingAlert.setToolTipText(this.noLineEndingAlert.getText());
        this.noLineEndingAlert.setForeground(pane.getBackground());
        Dimension minimumSize = new Dimension(this.noLineEndingAlert.getMinimumSize());
        minimumSize.setSize(minimumSize.getWidth() / 3.0, minimumSize.getHeight());
        this.noLineEndingAlert.setMinimumSize(minimumSize);
        this.lineEndings = new JComboBox<String>(new String[]{I18n.tr((String)"No line ending"), I18n.tr((String)"Newline"), I18n.tr((String)"Carriage return"), I18n.tr((String)"Both NL & CR")});
        this.lineEndings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PreferencesData.setInteger((String)"serial.line_ending", (int)AbstractTextMonitor.this.lineEndings.getSelectedIndex());
                AbstractTextMonitor.this.noLineEndingAlert.setForeground(pane.getBackground());
            }
        });
        if (PreferencesData.get((String)"serial.line_ending") != null) {
            this.lineEndings.setSelectedIndex(PreferencesData.getInteger((String)"serial.line_ending"));
        }
        this.lineEndings.setMaximumSize(this.lineEndings.getMinimumSize());
        this.serialRates = new JComboBox();
        for (String rate : this.serialRateStrings) {
            this.serialRates.addItem(rate + " " + I18n.tr((String)"baud"));
        }
        this.serialRates.setMaximumSize(this.serialRates.getMinimumSize());
        pane.add(this.autoscrollBox);
        pane.add(Box.createHorizontalGlue());
        pane.add(this.noLineEndingAlert);
        pane.add(Box.createRigidArea(new Dimension(8, 0)));
        pane.add(this.lineEndings);
        pane.add(Box.createRigidArea(new Dimension(8, 0)));
        pane.add(this.serialRates);
        pane.add(Box.createRigidArea(new Dimension(8, 0)));
        pane.add(this.clearButton);
        mainPane.add((Component)pane, "South");
    }

    @Override
    protected void onEnableWindow(boolean enable) {
        this.textArea.setEnabled(enable);
        this.clearButton.setEnabled(enable);
        this.scrollPane.setEnabled(enable);
        this.textField.setEnabled(enable);
        this.sendButton.setEnabled(enable);
        this.autoscrollBox.setEnabled(enable);
        this.lineEndings.setEnabled(enable);
        this.serialRates.setEnabled(enable);
    }

    public void onSendCommand(ActionListener listener) {
        this.textField.addActionListener(listener);
        this.sendButton.addActionListener(listener);
    }

    public void onClearCommand(ActionListener listener) {
        this.clearButton.addActionListener(listener);
    }

    public void onSerialRateChange(ActionListener listener) {
        this.serialRates.addActionListener(listener);
    }

    @Override
    public void message(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractTextMonitor.this.textArea.append(s);
                if (AbstractTextMonitor.this.autoscrollBox.isSelected()) {
                    AbstractTextMonitor.this.textArea.setCaretPosition(AbstractTextMonitor.this.textArea.getDocument().getLength());
                }
            }
        });
    }
}

