/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.jvm;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.perf.DefaultPerfHelper;
import com.sun.deploy.perf.DeployPerfUtil;
import com.sun.deploy.perf.PerfHelper;
import com.sun.deploy.util.ArgumentParsingUtil;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SystemUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.plugin2.jvm.JVMEventListener;
import sun.plugin2.jvm.ProcessLauncher;
import sun.plugin2.util.SystemUtil;

public class JVMLauncher
implements ProcessLauncher {
    private static final boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    private long jvmLaunchTime;
    private long appletLaunchTime;
    private String javaHome;
    private JVMParameters params;
    private boolean isRelaunch = false;
    private JREInfo jreInfo = null;
    private Process process;
    private volatile boolean exited;
    private int exitCode = -1;
    private Exception error;
    private List listeners = new ArrayList();

    public JVMLauncher(long l, String string, JVMParameters jVMParameters, boolean bl) {
        this.appletLaunchTime = l;
        this.javaHome = string;
        this.jreInfo = JREInfo.findByJREPath((String)string);
        this.params = jVMParameters;
        this.isRelaunch = bl;
    }

    public synchronized void addJVMEventListener(JVMEventListener jVMEventListener) {
        this.listeners.add(jVMEventListener);
    }

    public void start() {
        Object object;
        String[] stringArray;
        Object object2;
        Object object3;
        List list;
        Object object4;
        this.jvmLaunchTime = SystemUtils.microTime();
        if (DEBUG) {
            System.out.println("JVMLauncher.start: launcher params:");
            List list2 = this.params.getCommandLineArguments(true);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                System.out.println("\t<" + (String)iterator.next() + ">");
            }
        }
        if (DEBUG) {
            System.out.println("JVMLauncher.start(): now - user.startApplet(): " + (this.jvmLaunchTime - this.appletLaunchTime) + " us");
        }
        if (DeployPerfUtil.isEnabled()) {
            DeployPerfUtil.initialize((PerfHelper)new DefaultPerfHelper(this.appletLaunchTime));
        }
        long l = DeployPerfUtil.put((long)0L, (String)"JVMLauncher.start() - BEGIN");
        String string = "-D__applet_launched=" + this.appletLaunchTime;
        String string2 = "-D__jvm_launched=" + this.jvmLaunchTime;
        int n = Config.getMaxCommandLineLength();
        String string3 = this.findJava();
        if (string3 == null) {
            throw new RuntimeException("Unable to locate the java launcher in java.home \"" + this.javaHome + "\"");
        }
        this.exited = false;
        this.error = null;
        if (Config.useSecureLaunch((JREInfo)this.jreInfo)) {
            object4 = this.findPlugin2VistaLauncher();
            if (object4 == null) {
                throw new RuntimeException("Unable to locate the Java Plug-In's custom launcher for Windows in java.home \"" + System.getProperty("java.home") + "\"");
            }
            n -= ((String)object4).length() + 1;
            n -= this.javaHome.length() + 1;
            n -= string2.length() + 1;
            list = this.params.getCommandLineArguments(false, true, true, true, true, n -= string.length() + 1);
            list.add(0, object4);
            list.add(1, string2);
            list.add(2, string);
        } else {
            int n2;
            n -= string3.length() + 1;
            n -= string2.length() + 1;
            list = this.params.getCommandLineArguments(false, true, true, true, false, n -= string.length() + 1);
            object3 = null;
            object2 = list.iterator();
            int n3 = list.size();
            for (n2 = 0; n2 < n3 && JVMParameters.isJVMCommandLineArgument((String)(object3 = (String)object2.next())); ++n2) {
            }
            if (n2 == n3) {
                this.exited = true;
                this.error = new RuntimeException("Invalid arguments: no main class found");
                this.fireJVMExited();
                return;
            }
            if (object3 != null && !((String)object3).equals("sun.plugin2.main.client.PluginMain")) {
                this.exited = true;
                this.error = new RuntimeException("Invalid arguments: PluginMain main class not found");
                this.fireJVMExited();
                return;
            }
            list.add(0, string3);
            list.add(1, string2);
            list.add(2, string);
        }
        DeployPerfUtil.put((String)"JVMLauncher.start() - post param parsing");
        object4 = list;
        if (Config.useSecureLaunch((JREInfo)this.jreInfo)) {
            JVMParameters jVMParameters = null;
            object3 = this.params.getCommandLineArguments(false, false, false, this.isRelaunch, false, Config.getMaxCommandLineLength());
            for (int i = 0; i < object3.size() && !(stringArray = (String[])object3.get(i)).equals("sun.plugin2.main.client.PluginMain"); ++i) {
                if (this.jreInfo.getVmArgs() != null && this.jreInfo.getVmArgs().contains((CharSequence)stringArray)) {
                    if (!DEBUG) continue;
                    System.out.println("skip: " + (String)stringArray);
                    continue;
                }
                if (jVMParameters == null) {
                    jVMParameters = new JVMParameters();
                }
                jVMParameters.setIncludeExtendedASCIIValues(true);
                jVMParameters.addArgument((String)stringArray);
            }
            if (DEBUG) {
                System.out.println("JVMLauncher, added secureJvmParms: " + jVMParameters);
            }
            object4 = ArgumentParsingUtil.getSecureLaunchArgs((JREInfo)this.jreInfo, (List)list, jVMParameters, (boolean)this.isRelaunch, (boolean)this.isRelaunch);
        }
        if (DEBUG) {
            String string4 = null;
            int n4 = 0;
            int n5 = 0;
            object = object4.iterator();
            while (object.hasNext()) {
                string4 = (String)object.next();
                n4 += string4.length() + 1;
                System.out.println("JVMLauncher.processArg[" + n5 + "]: " + string4);
            }
            System.out.println("JVMLauncher.processArgs total len: " + n4 + ", custArgsMaxLen: " + n);
        }
        DeployPerfUtil.put((String)"JVMLauncher.start() - pre ProcessBuilder cstr");
        ProcessBuilder processBuilder = new ProcessBuilder((List<String>)object4);
        DeployPerfUtil.put((String)"JVMLauncher.start() - post ProcessBuilder cstr");
        Map<String, String> map = processBuilder.environment();
        DeployPerfUtil.put((String)"JVMLauncher.start() - post ProcessBuilder env mapping");
        object2 = map.get("LD_LIBRARY_PATH");
        if (object2 != null) {
            stringArray = ((String)object2).split(File.pathSeparator);
            object = Config.getJREHome();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith((String)object)) continue;
                stringArray[i] = null;
            }
            String string5 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                string5 = string5 == null ? stringArray[i] : string5 + File.pathSeparator + stringArray[i];
            }
            map.put("LD_LIBRARY_PATH", string5);
        }
        if (OSType.isMac()) {
            map.put("LC_CTYPE", "UTF-8");
        }
        DeployPerfUtil.put((String)"JVMLauncher.start() - post ProcessBuilder env LD_LIBRARY_PATH");
        map.remove("CLASSPATH");
        DeployPerfUtil.put((String)"JVMLauncher.start() - post ProcessBuilder env cleanup ");
        try {
            DeployPerfUtil.put((String)"JVMLauncher.start() - pre process start ");
            this.process = Platform.get().startProcessBuilder(processBuilder);
            DeployPerfUtil.put((String)"JVMLauncher.start() - post process start ");
            this.afterStart();
        }
        catch (Exception exception) {
            this.exited = true;
            this.error = exception;
        }
        DeployPerfUtil.put((long)l, (String)"JVMLauncher.start() - END");
    }

    protected void afterStart() {
        System.out.println("JVMLauncher.afterStart(): starting JVM process watcher");
        new Thread(new JVMWatcher()).start();
    }

    public JVMParameters getParameters() {
        return this.params;
    }

    public void addParameter(String string) {
        this.params.addArgument(string);
    }

    public void clearUserArguments() {
        this.params.clearUserArguments();
    }

    public boolean exited() {
        return this.exited;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Exception getErrorDuringStartup() {
        return this.error;
    }

    public void destroy() {
        this.process.destroy();
    }

    public InputStream getInputStream() {
        if (this.process != null) {
            return this.process.getInputStream();
        }
        return null;
    }

    public InputStream getErrorStream() {
        if (this.process != null) {
            return this.process.getErrorStream();
        }
        return null;
    }

    public long getJVMLaunchTime() {
        return this.jvmLaunchTime;
    }

    public long getAppletLaunchTime() {
        return this.appletLaunchTime;
    }

    private String findJava() {
        String string = SystemUtil.formatExecutableName("java");
        String string2 = this.javaHome + File.separator + "bin" + File.separator + string;
        if (new File(string2).exists()) {
            return string2;
        }
        string2 = this.javaHome + File.separator + "jre" + File.separator + "bin" + File.separator + string;
        if (new File(string2).exists()) {
            return string2;
        }
        return null;
    }

    private String findPlugin2VistaLauncher() {
        String string = "jp2launcher.exe";
        String string2 = Environment.getDeploymentHomePath();
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if (new File(string2 = string2 + "bin" + File.separator + string).exists()) {
            return string2;
        }
        return null;
    }

    private synchronized List copyListeners() {
        return (List)((ArrayList)this.listeners).clone();
    }

    private void fireJVMExited() {
        for (JVMEventListener jVMEventListener : this.copyListeners()) {
            jVMEventListener.jvmExited(this);
        }
    }

    class JVMWatcher
    implements Runnable {
        JVMWatcher() {
        }

        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    JVMLauncher.this.exitCode = JVMLauncher.this.process.waitFor();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            JVMLauncher.this.exited = true;
            JVMLauncher.this.fireJVMExited();
        }
    }
}

