/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers.serial;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.discoverers.SerialDiscovery;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import processing.app.BaseNoGui;
import processing.app.Platform;
import processing.app.debug.TargetBoard;

public class SerialBoardsLister
extends TimerTask {
    private final SerialDiscovery serialDiscovery;
    private final List<BoardPort> boardPorts = new LinkedList<BoardPort>();
    private List<String> oldPorts = new LinkedList<String>();
    public boolean uploadInProgress = false;
    public boolean pausePolling = false;
    private BoardPort oldUploadBoardPort = null;

    public SerialBoardsLister(SerialDiscovery serialDiscovery) {
        this.serialDiscovery = serialDiscovery;
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 0L, 1000L);
    }

    public synchronized void retriggerDiscovery(boolean polled) {
        Platform platform = BaseNoGui.getPlatform();
        if (platform == null) {
            return;
        }
        if (polled && this.pausePolling) {
            return;
        }
        List<String> ports = platform.listSerials();
        if (ports.equals(this.oldPorts)) {
            return;
        }
        this.oldPorts.clear();
        this.oldPorts.addAll(ports);
        for (BoardPort board : this.boardPorts) {
            if (ports.contains(board.toString())) {
                if (!board.isOnline()) continue;
                ports.remove(ports.indexOf(board.toString()));
                continue;
            }
            if (this.uploadInProgress && board.isOnline()) {
                this.oldUploadBoardPort = board;
            }
            board.setOnlineStatus(false);
        }
        for (String newPort : ports) {
            String[] parts = newPort.split("_");
            if (parts.length < 3) continue;
            if (parts.length > 3) {
                for (int i = 1; i < parts.length - 2; ++i) {
                    parts[0] = parts[0] + "_" + parts[i];
                }
                parts[1] = parts[parts.length - 2];
                parts[2] = parts[parts.length - 1];
            }
            String port = parts[0];
            Map<String, Object> boardData = platform.resolveDeviceByVendorIdProductId(port, BaseNoGui.packages);
            BoardPort boardPort = null;
            boolean updatingInfos = false;
            int i = 0;
            for (BoardPort board : this.boardPorts) {
                if (board.toString().equals(newPort)) {
                    updatingInfos = true;
                    boardPort = this.boardPorts.get(i);
                    break;
                }
                ++i;
            }
            if (!updatingInfos) {
                boardPort = new BoardPort();
            }
            boardPort.setAddress(port);
            boardPort.setProtocol("serial");
            boardPort.setOnlineStatus(true);
            String label = port;
            if (boardData != null) {
                TargetBoard board;
                boardPort.getPrefs().put("vid", boardData.get("vid").toString());
                boardPort.getPrefs().put("pid", boardData.get("pid").toString());
                boardPort.setVIDPID(parts[1], parts[2]);
                String iserial = boardData.get("iserial").toString();
                if (iserial.length() >= 10) {
                    boardPort.getPrefs().put("iserial", iserial);
                    boardPort.setISerial(iserial);
                }
                if (this.uploadInProgress && this.oldUploadBoardPort != null) {
                    this.oldUploadBoardPort.getPrefs().put("iserial", iserial);
                    this.oldUploadBoardPort.setISerial(iserial);
                }
                if ((board = (TargetBoard)boardData.get("board")) != null) {
                    String boardName = board.getName();
                    if (boardName != null) {
                        label = label + " (" + boardName + ")";
                    }
                    boardPort.setBoardName(boardName);
                }
            } else if (!parts[1].equals("0000")) {
                boardPort.setVIDPID(parts[1], parts[2]);
                platform.getBoardWithMatchingVidPidFromCloud(parts[1], parts[2]);
            } else {
                boardPort.setVIDPID("0000", "0000");
                boardPort.setISerial("");
            }
            boardPort.setLabel(label);
            if (updatingInfos) continue;
            this.boardPorts.add(boardPort);
        }
        this.serialDiscovery.setSerialBoardPorts(this.boardPorts);
    }

    @Override
    public void run() {
        if (BaseNoGui.packages == null) {
            return;
        }
        this.retriggerDiscovery(true);
    }
}

