/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.server;

import com.sun.applet2.AppletParameters;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.Platform;
import com.sun.deploy.config.PluginServerConfig;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.VersionString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.plugin2.liveconnect.RemoteJavaObject;
import sun.plugin2.main.server.AppletID;
import sun.plugin2.main.server.ClientJVMSelectionParameters;
import sun.plugin2.main.server.JVMInstance;
import sun.plugin2.main.server.Plugin;
import sun.plugin2.message.AppletMessage;
import sun.plugin2.message.Conversation;
import sun.plugin2.util.SystemUtil;

public class JVMManager {
    static boolean DEBUG = SystemUtil.isDebug();
    static boolean VERBOSE = SystemUtil.isVerbose();
    private static final String JPI_USER_PROFILE = "javaplugin.user.profile";
    private static JVMManager soleInstance;
    private static final int RETRY_COUNT = 2;
    private static int browserType;
    private static boolean isModalityDisabled;
    private String userJPIProfile;
    private Map activeJVMs = new HashMap();
    private int curJVMID;
    private final List javaPlatformList = new ArrayList();
    private JREInfo defaultJREInfo;
    private Map javaParamMap = new IdentityHashMap();
    private int curAppletID;
    private Map appletToJVMMap = new HashMap();
    private Map appletMessageQueue = new HashMap();

    private JVMManager() {
        this.userJPIProfile = SystemUtil.getenv("USER_JPI_PROFILE");
        if (this.userJPIProfile != null) {
            System.setProperty(JPI_USER_PROFILE, this.userJPIProfile);
        }
        Config.setInstance((Config)new PluginServerConfig());
        this.processJREInfo();
        Platform.get().getAutoUpdater().checkForUpdate(null);
    }

    public static void setBrowserType(int n) {
        browserType = n;
    }

    public static void setModalityDisabled(boolean bl) {
        isModalityDisabled = bl;
    }

    public static int getBrowserType() {
        return browserType;
    }

    public static boolean isModalityDisabled() {
        return isModalityDisabled;
    }

    public static synchronized JVMManager getManager() {
        if (soleInstance == null) {
            soleInstance = new JVMManager();
        }
        return soleInstance;
    }

    public boolean instanceExited(int n) {
        return this.getJVMInstance(n) == null;
    }

    public boolean appletExited(AppletID appletID) {
        for (JVMInstance jVMInstance : this.activeJVMs.values()) {
            if (!jVMInstance.appletRunning(appletID)) continue;
            return false;
        }
        return true;
    }

    public AppletID startApplet(AppletParameters appletParameters, Plugin plugin, long l, String string, boolean bl) {
        return this.startApplet(appletParameters, plugin, l, string, bl, (String)appletParameters.get((Object)"java_version"));
    }

    public AppletID startApplet(AppletParameters appletParameters, Plugin plugin, long l, String string, boolean bl, String string2) {
        return this.startAppletImpl(SystemUtils.microTime(), appletParameters, plugin, l, string, bl, false, string2, false, this.nextAppletID(), false);
    }

    public AppletID startDummyApplet(AppletParameters appletParameters, Plugin plugin) {
        return this.startAppletImpl(SystemUtils.microTime(), appletParameters, plugin, 0L, null, false, false, (String)appletParameters.get((Object)"java_version"), true, this.nextAppletID(), false);
    }

    public AppletID relaunchApplet(long l, AppletParameters appletParameters, Plugin plugin, long l2, String string, boolean bl, boolean bl2, String string2, int n, boolean bl3) {
        if (bl3) {
            this.processJREInfo();
        }
        return this.startAppletImpl(l, appletParameters, plugin, l2, string, bl, bl2, string2, false, n, true);
    }

    private void maintainCurrentArchFlag(JVMParameters jVMParameters, JREInfo jREInfo) {
        if (SystemUtil.getOSType() == 3 && !jVMParameters.contains("-d32") && !jVMParameters.contains("-d64")) {
            if ("x86_64".equals(jREInfo.getOSArch()) || "amd64".equals(jREInfo.getOSArch())) {
                jVMParameters.addInternalArgument("-d64");
            } else {
                jVMParameters.addInternalArgument("-d32");
            }
        }
    }

    VersionString getVersionStringToRunAndSetSsvVersion(String string, AppletParameters appletParameters) {
        VersionString versionString = new VersionString(string);
        String string2 = JVMManager.noDash(this.getBestJREInfo(versionString).getProduct());
        if (versionString.contains(string2)) {
            if (SecurityBaseline.satisfiesSecurityBaseline((String)string2)) {
                return new VersionString(string2);
            }
            appletParameters.put((Object)"__applet_ssv_version", (Object)string2);
        } else {
            appletParameters.put((Object)"__applet_request_version", (Object)string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppletID startAppletImpl(long l, AppletParameters appletParameters, Plugin plugin, long l2, String string, boolean bl, boolean bl2, String string2, boolean bl3, int n, boolean bl4) {
        VersionString versionString = null;
        if (string2 != null) {
            versionString = bl4 ? new VersionString(string2) : this.getVersionStringToRunAndSetSsvVersion(string2, appletParameters);
        }
        JVMParameters jVMParameters = SystemUtil.extractAppletParamsToJVMParameters(appletParameters, plugin.getDocumentBase(), bl4, false);
        int n2 = 0;
        ClientJVMSelectionParameters clientJVMSelectionParameters = ClientJVMSelectionParameters.extract((Map)appletParameters);
        AppletID appletID = new AppletID(n);
        String string3 = plugin.getDocumentBase();
        do {
            JVMInstance jVMInstance;
            if (null == (jVMInstance = this.getOrCreateBestJVMInstance(l, (VersionString)(bl4 ? versionString : null), jVMParameters, clientJVMSelectionParameters, bl4 ? appletID : null, string3, bl2, bl4))) {
                plugin.startupStatus(3);
                return null;
            }
            this.checkRelaunchParameters(versionString, jVMInstance.getJavaInfo(), appletParameters);
            if (!jVMInstance.exited() && jVMInstance.startApplet(appletParameters, plugin, l2, string, bl, n, bl3, bl4, bl2)) {
                this.appletToJVMMap.put(appletID, jVMInstance);
                Map map = this.appletMessageQueue;
                synchronized (map) {
                    if (null == this.appletMessageQueue.get(appletID)) {
                        this.appletMessageQueue.put(appletID, new ArrayList());
                    }
                }
                if (DEBUG) {
                    System.out.println("JVMManager: applet launch (ID " + appletID + ") succeeded");
                }
                return appletID;
            }
            if (!DEBUG || !jVMInstance.errorOccurred()) continue;
            System.out.println("Error occurred during launch of JVM");
        } while (++n2 < 2);
        return null;
    }

    private void checkRelaunchParameters(VersionString versionString, JREInfo jREInfo, AppletParameters appletParameters) {
        if (appletParameters.get((Object)"__applet_ssv_version") == null && appletParameters.get((Object)"__applet_request_version") == null) {
            JREInfo jREInfo2 = null;
            boolean bl = false;
            JREInfo jREInfo3 = null;
            for (JREInfo jREInfo4 : this.javaPlatformList) {
                if (!jREInfo4.isEnabled() || jREInfo4.isFakeJRE()) continue;
                if (jREInfo.getProductVersion().equals((Object)jREInfo4.getProductVersion())) {
                    bl = true;
                }
                if (versionString != null && versionString.contains(JVMManager.noDash(jREInfo4.getProduct())) && (jREInfo2 == null || jREInfo4.getProductVersion().isGreaterThan(jREInfo2.getProductVersion()))) {
                    jREInfo2 = jREInfo4;
                }
                if (bl || jREInfo2 != null || jREInfo3 != null && !jREInfo4.getProductVersion().isGreaterThan(jREInfo3.getProductVersion())) continue;
                jREInfo3 = jREInfo4;
            }
            Object object = null;
            if (jREInfo2 != null) {
                object = jREInfo2.getProductVersion().toString();
            } else if (versionString != null && versionString.contains(JVMManager.noDash(jREInfo.getProduct()))) {
                object = jREInfo.getProductVersion().toString();
            } else if (!bl && jREInfo3 != null) {
                object = jREInfo3.getProductVersion().toString();
            }
            if (object != null) {
                appletParameters.put((Object)"__applet_ssv_version", object);
            }
        }
    }

    public void setAppletSize(AppletID appletID, int n, int n2) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.setAppletSize(appletID.getID(), n, n2);
    }

    public void sendStopApplet(AppletID appletID) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendStopApplet(appletID.getID());
    }

    public boolean receivedStopAcknowledgment(AppletID appletID) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return false;
        }
        return jVMInstance.receivedStopAcknowledgment(appletID.getID());
    }

    public void recycleAppletID(AppletID appletID) {
        JVMInstance jVMInstance = this.removeJVMInstance(appletID);
        if (jVMInstance != null) {
            jVMInstance.recycleAppletID(appletID.getID());
        }
        this.removeAppletMessageQueue(appletID);
    }

    public void sendGetApplet(AppletID appletID, int n) throws IOException {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            throw new IOException("No active JVM instance for applet ID " + appletID);
        }
        jVMInstance.sendGetApplet(appletID.getID(), n);
    }

    public void sendGetNameSpace(AppletID appletID, String string, int n) throws IOException {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            throw new IOException("No active JVM instance for applet ID " + appletID);
        }
        jVMInstance.sendGetNameSpace(appletID.getID(), string, n);
    }

    public void sendRemoteJavaObjectOp(Conversation conversation, RemoteJavaObject remoteJavaObject, String string, int n, Object[] objectArray, int n2) throws IOException {
        JVMInstance jVMInstance = this.getJVMInstance(new AppletID(remoteJavaObject.getAppletID()));
        if (jVMInstance == null) {
            throw new IOException("No active JVM instance for applet ID " + remoteJavaObject.getAppletID() + ", JVM ID " + remoteJavaObject.getJVMID());
        }
        jVMInstance.sendRemoteJavaObjectOp(conversation, remoteJavaObject, string, n, objectArray, n2);
    }

    public void releaseRemoteJavaObject(RemoteJavaObject remoteJavaObject) {
        JVMInstance jVMInstance = this.getJVMInstance(remoteJavaObject.getJVMID());
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.releaseRemoteJavaObject(remoteJavaObject.getObjectID());
    }

    public void sendWindowActivation(AppletID appletID, boolean bl) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.synthesizeWindowActivation(appletID.getID(), bl);
    }

    public void sendGotFocus(AppletID appletID, boolean bl) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendGotFocus(appletID.getID(), bl);
    }

    public void sendOverlayWindowMove(AppletID appletID, double d, double d2) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendOverlayWindowMove(appletID.getID(), d, d2);
    }

    public void sendMouseEvent(AppletID appletID, int n, int n2, double d, double d2, int n3, int n4) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendMouseEvent(appletID.getID(), n, n2, d, d2, n3, n4);
    }

    public void sendKeyEvent(AppletID appletID, int n, int n2, String string, String string2, boolean bl, int n3, boolean bl2) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendKeyEvent(appletID.getID(), n, n2, string, string2, bl, n3, bl2);
    }

    public void sendScrollEvent(AppletID appletID, double d, double d2, int n, double d3, double d4, double d5) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendScrollEvent(appletID.getID(), d, d2, n, d3, d4, d5);
    }

    public void sendTextEvent(AppletID appletID, String string) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendTextEvent(appletID.getID(), string);
    }

    public boolean printApplet(AppletID appletID, long l, int n, int n2, int n3, int n4) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return false;
        }
        return jVMInstance.printApplet(appletID.getID(), l, n, n2, n3, n4);
    }

    public boolean isMoreRecentJVMAvailable(JREInfo jREInfo) {
        for (JREInfo jREInfo2 : this.javaPlatformList) {
            if (DEBUG) {
                System.out.println("isMoreRecentJVMAvailable considering " + jREInfo2.getProductVersion() + " JVM for relaunch");
            }
            if (!jREInfo2.getProductVersion().isGreaterThan(jREInfo.getProductVersion())) continue;
            if (DEBUG) {
                System.out.println("  isMoreRecentJVMAvailable (chosen)");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean spoolAppletMessage(AppletMessage appletMessage) {
        Map map = this.appletMessageQueue;
        synchronized (map) {
            List list = (List)this.appletMessageQueue.get(new AppletID(appletMessage.getAppletID()));
            if (list != null) {
                if (DEBUG && VERBOSE) {
                    System.out.println("Spool AppletMessage: " + appletMessage);
                }
                list.add(appletMessage);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drainAppletMessages(AppletID appletID) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null && DEBUG) {
            System.out.println("JVMManager.drainAppletMessages: no JVM instance for applet ID " + appletID);
            return;
        }
        Map map = this.appletMessageQueue;
        synchronized (map) {
            List list = (List)this.appletMessageQueue.remove(appletID);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    try {
                        AppletMessage appletMessage = (AppletMessage)iterator.next();
                        if (DEBUG && VERBOSE) {
                            System.out.println("Drain AppletMessage: " + appletMessage);
                        }
                        jVMInstance.sendMessageDirect(appletMessage);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAppletMessageQueue(AppletID appletID) {
        Map map = this.appletMessageQueue;
        synchronized (map) {
            this.appletMessageQueue.remove(appletID);
        }
    }

    protected synchronized int getJVMIDForApplet(AppletID appletID) {
        JVMInstance jVMInstance = (JVMInstance)this.appletToJVMMap.get(appletID);
        return null != jVMInstance ? jVMInstance.getID() : -1;
    }

    synchronized JVMInstance getJVMInstance(AppletID appletID) {
        return (JVMInstance)this.appletToJVMMap.get(appletID);
    }

    private synchronized JVMInstance getJVMInstance(int n) {
        return (JVMInstance)this.activeJVMs.get(new Integer(n));
    }

    private synchronized JVMInstance removeJVMInstance(AppletID appletID) {
        return (JVMInstance)this.appletToJVMMap.remove(appletID);
    }

    private synchronized int nextJVMID() {
        int n;
        while (this.activeJVMs.get(new Integer(n = ++this.curJVMID)) != null) {
        }
        return n;
    }

    private synchronized void processJREInfo() {
        Config.get().refreshIfNeeded();
        if (DEBUG && VERBOSE) {
            System.out.println("JREInfos (1)");
            JREInfo.printJREs();
        }
        Config.get().updateJREs();
        if (DEBUG && VERBOSE) {
            System.out.println("JREInfos (2)");
            JREInfo.printJREs();
        }
        this.javaPlatformList.clear();
        this.javaPlatformList.addAll(Arrays.asList(JREInfo.getValidSorted()));
        if (!this.javaPlatformList.isEmpty()) {
            this.defaultJREInfo = (JREInfo)this.javaPlatformList.get(0);
        }
        JVMManager.filterDisabledJREs(this.javaPlatformList);
        this.updateJavaParamMap();
    }

    private void updateJavaParamMap() {
        for (JREInfo jREInfo : this.javaPlatformList) {
            JVMParameters jVMParameters = SystemUtil.getDefaultVmArgs(jREInfo);
            this.javaParamMap.put(jREInfo, jVMParameters);
        }
    }

    JREInfo getBestJREInfo(VersionString versionString) {
        return this.getBestJREInfo(versionString, null);
    }

    synchronized JREInfo getBestJREInfo(VersionString versionString, VersionString versionString2) {
        boolean bl = false;
        if (versionString == null) {
            return this.defaultJREInfo;
        }
        while (true) {
            if (bl) {
                Config.get().refreshIfNeeded();
                this.processJREInfo();
            }
            Trace.println((String)("Iterate javaPlatformList:[" + this.javaPlatformList.size() + "] for " + versionString), (TraceLevel)TraceLevel.NETWORK);
            for (JREInfo jREInfo : this.javaPlatformList) {
                if (versionString.contains(jREInfo.getProductVersion())) {
                    return jREInfo;
                }
                Trace.println((String)("Iterate javaPlatformList: " + jREInfo.getProductVersion()), (TraceLevel)TraceLevel.NETWORK);
            }
            if (bl) break;
            bl = true;
            Trace.println((String)"Retry javaPlatformList ", (TraceLevel)TraceLevel.NETWORK);
        }
        Trace.println((String)"Exit javaPlatformList ", (TraceLevel)TraceLevel.NETWORK);
        return this.defaultJREInfo;
    }

    synchronized JVMInstance getOrCreateBestJVMInstance(long l, VersionString versionString, JVMParameters jVMParameters, ClientJVMSelectionParameters clientJVMSelectionParameters, AppletID appletID, String string, boolean bl, boolean bl2) {
        Object object;
        JVMInstance jVMInstance = null;
        if (!clientJVMSelectionParameters.isSeparateJVM()) {
            jVMInstance = this.getBestJVMInstance(versionString, jVMParameters, clientJVMSelectionParameters, string, bl);
            if (jVMInstance != null) {
                if (DEBUG) {
                    System.out.println("JVMManager reusing JVMInstance for product version " + jVMInstance.getProductVersion());
                    System.out.println("\t Set AppletLaunchTime: " + l);
                }
                jVMInstance.setAppletLaunchTime(l);
                return jVMInstance;
            }
            object = this.getBestJREInfo(versionString);
            jVMInstance = this.getBestJVMInstance(new VersionString(object.getProductVersion()), jVMParameters, clientJVMSelectionParameters, string, bl);
            if (jVMInstance != null) {
                if (DEBUG) {
                    System.out.println("JVMManager reusing JVMInstance for product version " + jVMInstance.getProductVersion());
                    System.out.println("\t Set AppletLaunchTime: " + l);
                }
                jVMInstance.setAppletLaunchTime(l);
                return jVMInstance;
            }
        }
        if ((jVMInstance = this.createJVMInstance(l, versionString, jVMParameters, clientJVMSelectionParameters, appletID, string, bl, bl2)) == null) {
            if (DEBUG) {
                System.out.print("Cannot find a suitable JRE.");
            }
            return null;
        }
        if (DEBUG) {
            System.out.println("JVMManager starting JVMInstance for product version " + jVMInstance.getProductVersion());
            object = jVMInstance.getParameters().getCommandLineArguments(SystemUtil.getOSType() == 1);
            if (object.size() > 0) {
                System.out.println("  Command-line arguments: ");
                for (int i = 0; i < object.size(); ++i) {
                    System.out.println("    Argument " + i + ": " + object.get(i));
                }
            }
        }
        try {
            jVMInstance.start();
            return jVMInstance;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            error.printStackTrace();
            throw error;
        }
    }

    synchronized JVMInstance getBestJVMInstance(VersionString versionString, JVMParameters jVMParameters, ClientJVMSelectionParameters clientJVMSelectionParameters, String string, boolean bl) {
        Object object2;
        if (clientJVMSelectionParameters.isSeparateJVM()) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Object object2 : this.activeJVMs.values()) {
            if (!((JVMInstance)object2).exited()) continue;
            arrayList.add(new Integer(((JVMInstance)object2).getID()));
        }
        Object object3 = arrayList.iterator();
        while (object3.hasNext()) {
            this.activeJVMs.remove(object3.next());
        }
        if (DEBUG) {
            System.out.println("Seeking suitable JRE for version IDs: " + versionString);
            System.out.println("and JVMParameters: " + jVMParameters);
            System.out.println(this.activeJVMs.values().size() + " active JVM(s)");
        }
        object3 = null;
        for (Object object4 : this.activeJVMs.values()) {
            if (DEBUG) {
                System.out.println("Considering for reuse: " + object4);
            }
            if (((JVMInstance)object4).isNativeSandbox() != bl) {
                if (!DEBUG) continue;
                System.out.println("\tRejected by native sandbox unmatch");
                continue;
            }
            if (((JVMInstance)object4).isExclusive()) {
                if (!DEBUG) continue;
                System.out.println("\tRejected by exclusive instance");
                continue;
            }
            if (!((JVMInstance)object4).isHealthy()) {
                if (!DEBUG) continue;
                System.out.println("\tRejected by unhealthy: " + ((JVMInstance)object4).getHealthData());
                continue;
            }
            if (!clientJVMSelectionParameters.match((JVMInstance)object4)) {
                if (!DEBUG) continue;
                System.out.println("\tRejected by targetJVMSelectionPreferences: " + clientJVMSelectionParameters);
                continue;
            }
            if (versionString != null && !versionString.contains(((JVMInstance)object4).getProductVersion())) {
                if (!DEBUG) continue;
                System.out.println("\tRejected by unmatch version: " + ((JVMInstance)object4).getProductVersion());
                continue;
            }
            if (!((JVMInstance)object4).getParameters().satisfies(jVMParameters)) {
                if (!DEBUG) continue;
                System.out.println("\tRejected by unsatisfied parameters: " + ((JVMInstance)object4).getParameters());
                continue;
            }
            if (object3 != null && !((JVMInstance)object4).getProductVersion().isGreaterThan(((JVMInstance)object3).getProductVersion())) {
                if (!DEBUG) continue;
                System.out.println("\tRejected, not later than current best: " + ((JVMInstance)object3).getProductVersion());
                continue;
            }
            if (!((JVMInstance)object4).canUse(string)) {
                if (!DEBUG) continue;
                System.out.println("\tRejected, not allowed docbase: " + string);
                continue;
            }
            object3 = object4;
            if (!DEBUG) continue;
            System.out.println("  Selected: " + ((JVMInstance)object3).getProductVersion());
        }
        if (DEBUG) {
            System.out.println("Selecting a matched JREInfo...");
        }
        object2 = null;
        for (JREInfo jREInfo : this.javaPlatformList) {
            if (DEBUG) {
                System.out.println("Considering " + jREInfo.getProductVersion() + " JVM for launch");
            }
            if ((versionString == null || versionString.contains(jREInfo.getProductVersion())) && (object2 == null || jREInfo.getProductVersion().isGreaterThan(object2.getProductVersion()))) {
                object2 = jREInfo;
                if (!DEBUG) continue;
                System.out.println("  (chosen)");
                continue;
            }
            if (!DEBUG) continue;
            System.out.println("  (rejected)");
        }
        if (object3 != null) {
            if (object2 == null) {
                throw new InternalError("Should not find a running JVM instance but no matching JRE platform");
            }
            if (((JVMInstance)object3).getProductVersion().isGreaterThanOrEqual(object2.getProductVersion())) {
                if (DEBUG) {
                    System.out.println("Reusing JVM instance with product version " + ((JVMInstance)object3).getProductVersion() + "; best available product version " + object2.getProductVersion());
                }
                return object3;
            }
            if (DEBUG) {
                System.out.println("NOT reusing JVM instance with product version " + ((JVMInstance)object3).getProductVersion() + "; best available product version " + object2.getProductVersion());
            }
        } else if (DEBUG) {
            System.out.println("No suitable JVM instance to reuse");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JVMInstance createJVMInstance(long l, VersionString versionString, JVMParameters jVMParameters, ClientJVMSelectionParameters clientJVMSelectionParameters, AppletID appletID, String string, boolean bl, boolean bl2) {
        JREInfo jREInfo = this.getBestJREInfo(versionString, new VersionString(clientJVMSelectionParameters.getJfxRequirement()));
        if (jREInfo == null) {
            return null;
        }
        JVMParameters jVMParameters2 = SystemUtil.prepareJVMParameter(jVMParameters, jREInfo, (JVMParameters)this.javaParamMap.get(jREInfo), clientJVMSelectionParameters, bl2);
        if (this.userJPIProfile != null) {
            jVMParameters2.addInternalArgument("-Djavaplugin.user.profile=" + this.userJPIProfile);
        }
        if (DEBUG) {
            System.out.println("JVMManager creating JVMInstance for product version " + jREInfo.getProductVersion());
        }
        int n = this.nextJVMID();
        JVMInstance jVMInstance = new JVMInstance(l, n, jREInfo, jVMParameters2, clientJVMSelectionParameters.isSeparateJVM(), appletID, string, bl);
        boolean bl3 = false;
        JfxRuntime jfxRuntime = null;
        if (clientJVMSelectionParameters.getJfxRequirement() != null) {
            jfxRuntime = jREInfo.getJfxRuntime();
            bl3 = jfxRuntime != null && clientJVMSelectionParameters.useJfxToolkit();
        }
        jVMInstance.setJfxSupport(jfxRuntime);
        jVMInstance.setUseJfxToolkit(bl3);
        JVMManager jVMManager = this;
        synchronized (jVMManager) {
            this.activeJVMs.put(new Integer(n), jVMInstance);
        }
        return jVMInstance;
    }

    private synchronized int nextAppletID() {
        return ++this.curAppletID;
    }

    private static void filterDisabledJREs(List list) {
        String string = SystemUtil.getJavaHome();
        JREInfo jREInfo = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JREInfo jREInfo2 = (JREInfo)iterator.next();
            if (jREInfo2.getJREPath().startsWith(string)) {
                jREInfo = jREInfo2;
            }
            if (jREInfo2.isEnabled()) continue;
            iterator.remove();
        }
        if (list.isEmpty() && jREInfo != null) {
            list.add(jREInfo);
        }
    }

    void setJavaPlatformListForTest(List list) {
        this.javaPlatformList.clear();
        this.javaPlatformList.addAll(list);
        if (!this.javaPlatformList.isEmpty()) {
            this.defaultJREInfo = (JREInfo)this.javaPlatformList.get(0);
        }
        this.updateJavaParamMap();
    }

    static void resetInstanceForTest() {
        soleInstance = null;
    }

    private static String noDash(String string) {
        int n = string.indexOf("-");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }
}

