/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import cc.arduino.packages.discoverers.NetworkDiscovery;
import cc.arduino.packages.discoverers.SerialDiscovery;
import java.util.ArrayList;
import java.util.List;
import processing.app.I18n;

public class DiscoveryManager {
    private final List<Discovery> discoverers;
    private final SerialDiscovery serialDiscoverer = new SerialDiscovery();
    private final NetworkDiscovery networkDiscoverer = new NetworkDiscovery();

    public DiscoveryManager() {
        this.discoverers = new ArrayList<Discovery>();
        this.discoverers.add(this.serialDiscoverer);
        this.discoverers.add(this.networkDiscoverer);
        for (Discovery d : this.discoverers) {
            try {
                d.start();
            }
            catch (Exception e) {
                System.err.println(I18n.tr("Error starting discovery method: ") + d.getClass());
                e.printStackTrace();
            }
        }
        Thread closeHook = new Thread(() -> {
            for (Discovery d : this.discoverers) {
                try {
                    d.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        closeHook.setName("DiscoveryManager closeHook");
        Runtime.getRuntime().addShutdownHook(closeHook);
    }

    public SerialDiscovery getSerialDiscoverer() {
        return this.serialDiscoverer;
    }

    public List<BoardPort> discovery() {
        ArrayList<BoardPort> res = new ArrayList<BoardPort>();
        for (Discovery d : this.discoverers) {
            res.addAll(d.listDiscoveredBoards());
        }
        return res;
    }

    public List<BoardPort> discovery(boolean complete) {
        ArrayList<BoardPort> res = new ArrayList<BoardPort>();
        for (Discovery d : this.discoverers) {
            res.addAll(d.listDiscoveredBoards(complete));
        }
        return res;
    }

    public BoardPort find(String address) {
        for (BoardPort boardPort : this.discovery()) {
            if (!boardPort.getAddress().equals(address)) continue;
            return boardPort;
        }
        return null;
    }

    public BoardPort find(String address, boolean complete) {
        for (BoardPort boardPort : this.discovery(complete)) {
            if (!boardPort.getAddress().equals(address)) continue;
            return boardPort;
        }
        return null;
    }
}

