/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ClassLoaderUtils {
    private static final Logger log = Logger.getLogger(ClassLoaderUtils.class.getName());

    private ClassLoaderUtils() {
    }

    static URL getResource(String string, Class<?> clazz) {
        ClassLoader classLoader;
        ClassLoader classLoader2;
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL == null && string.startsWith("/")) {
            uRL = Thread.currentThread().getContextClassLoader().getResource(string.substring(1));
        }
        if ((classLoader2 = ClassLoaderUtils.class.getClassLoader()) == null) {
            classLoader2 = ClassLoader.getSystemClassLoader();
        }
        if (uRL == null) {
            uRL = classLoader2.getResource(string);
        }
        if (uRL == null && string.startsWith("/")) {
            uRL = classLoader2.getResource(string.substring(1));
        }
        if (uRL == null && (classLoader = clazz.getClassLoader()) != null) {
            uRL = classLoader.getResource(string);
        }
        if (uRL == null) {
            uRL = clazz.getResource(string);
        }
        if (uRL == null && string != null && string.charAt(0) != '/') {
            return ClassLoaderUtils.getResource('/' + string, clazz);
        }
        return uRL;
    }

    static List<URL> getResources(String string, Class<?> clazz) {
        Object object;
        Enumeration<URL> enumeration;
        ArrayList<URL> arrayList;
        block22: {
            block21: {
                ClassLoader classLoader;
                block20: {
                    block19: {
                        block18: {
                            arrayList = new ArrayList<URL>();
                            enumeration = new Enumeration<URL>(){

                                @Override
                                public boolean hasMoreElements() {
                                    return false;
                                }

                                @Override
                                public URL nextElement() {
                                    return null;
                                }
                            };
                            try {
                                enumeration = Thread.currentThread().getContextClassLoader().getResources(string);
                            }
                            catch (IOException iOException) {
                                if (!log.isLoggable(Level.FINE)) break block18;
                                log.log(Level.FINE, iOException.getMessage(), iOException);
                            }
                        }
                        if (!enumeration.hasMoreElements() && string.startsWith("/")) {
                            try {
                                enumeration = Thread.currentThread().getContextClassLoader().getResources(string.substring(1));
                            }
                            catch (IOException iOException) {
                                if (!log.isLoggable(Level.FINE)) break block19;
                                log.log(Level.FINE, iOException.getMessage(), iOException);
                            }
                        }
                    }
                    if ((classLoader = ClassLoaderUtils.class.getClassLoader()) == null) {
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                    if (!enumeration.hasMoreElements()) {
                        try {
                            enumeration = classLoader.getResources(string);
                        }
                        catch (IOException iOException) {
                            if (!log.isLoggable(Level.FINE)) break block20;
                            log.log(Level.FINE, iOException.getMessage(), iOException);
                        }
                    }
                }
                if (!enumeration.hasMoreElements() && string.startsWith("/")) {
                    try {
                        enumeration = classLoader.getResources(string.substring(1));
                    }
                    catch (IOException iOException) {
                        if (!log.isLoggable(Level.FINE)) break block21;
                        log.log(Level.FINE, iOException.getMessage(), iOException);
                    }
                }
            }
            if (!enumeration.hasMoreElements() && (object = clazz.getClassLoader()) != null) {
                try {
                    enumeration = ((ClassLoader)object).getResources(string);
                }
                catch (IOException iOException) {
                    if (!log.isLoggable(Level.FINE)) break block22;
                    log.log(Level.FINE, iOException.getMessage(), iOException);
                }
            }
        }
        if (!enumeration.hasMoreElements() && (object = clazz.getResource(string)) != null) {
            arrayList.add((URL)object);
        }
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        if (arrayList.isEmpty() && string != null && string.charAt(0) != '/') {
            return ClassLoaderUtils.getResources('/' + string, clazz);
        }
        return arrayList;
    }

    static InputStream getResourceAsStream(String string, Class<?> clazz) {
        URL uRL = ClassLoaderUtils.getResource(string, clazz);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, iOException.getMessage(), iOException);
            }
            return null;
        }
    }

    static Class<?> loadClass(String string, Class<?> clazz) throws ClassNotFoundException {
        block3: {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    return classLoader.loadClass(string);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!log.isLoggable(Level.FINE)) break block3;
                log.log(Level.FINE, classNotFoundException.getMessage(), classNotFoundException);
            }
        }
        return ClassLoaderUtils.loadClass2(string, clazz);
    }

    private static Class<?> loadClass2(String string, Class<?> clazz) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            block6: {
                try {
                    if (ClassLoaderUtils.class.getClassLoader() != null) {
                        return ClassLoaderUtils.class.getClassLoader().loadClass(string);
                    }
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    if (clazz == null || clazz.getClassLoader() == null) break block6;
                    return clazz.getClassLoader().loadClass(string);
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, classNotFoundException.getMessage(), classNotFoundException);
            }
            throw classNotFoundException;
        }
    }
}

