/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import com.sun.jmx.snmp.IPAcl.AclEntryImpl;
import com.sun.jmx.snmp.IPAcl.OwnerImpl;
import com.sun.jmx.snmp.IPAcl.PrincipalImpl;
import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

class AclImpl
extends OwnerImpl
implements Acl,
Serializable {
    private static final long serialVersionUID = -2250957591085270029L;
    private Vector<AclEntry> entryList = new Vector();
    private String aclName = null;

    public AclImpl(PrincipalImpl principalImpl, String string) {
        super(principalImpl);
        this.aclName = string;
    }

    @Override
    public void setName(Principal principal, String string) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        this.aclName = string;
    }

    @Override
    public String getName() {
        return this.aclName;
    }

    @Override
    public boolean addEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        if (this.entryList.contains(aclEntry)) {
            return false;
        }
        this.entryList.addElement(aclEntry);
        return true;
    }

    @Override
    public boolean removeEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        return this.entryList.removeElement(aclEntry);
    }

    public void removeAll(Principal principal) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        this.entryList.removeAllElements();
    }

    @Override
    public Enumeration<Permission> getPermissions(Principal principal) {
        Vector vector = new Vector();
        Enumeration<AclEntry> enumeration = this.entryList.elements();
        while (enumeration.hasMoreElements()) {
            AclEntry aclEntry = enumeration.nextElement();
            if (!aclEntry.getPrincipal().equals(principal)) continue;
            return aclEntry.permissions();
        }
        return vector.elements();
    }

    @Override
    public Enumeration<AclEntry> entries() {
        return this.entryList.elements();
    }

    @Override
    public boolean checkPermission(Principal principal, Permission permission) {
        Enumeration<AclEntry> enumeration = this.entryList.elements();
        while (enumeration.hasMoreElements()) {
            AclEntry aclEntry = enumeration.nextElement();
            if (!aclEntry.getPrincipal().equals(principal) || !aclEntry.checkPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPermission(Principal principal, String string, Permission permission) {
        Enumeration<AclEntry> enumeration = this.entryList.elements();
        while (enumeration.hasMoreElements()) {
            AclEntryImpl aclEntryImpl = (AclEntryImpl)enumeration.nextElement();
            if (!aclEntryImpl.getPrincipal().equals(principal) || !aclEntryImpl.checkPermission(permission) || !aclEntryImpl.checkCommunity(string)) continue;
            return true;
        }
        return false;
    }

    public boolean checkCommunity(String string) {
        Enumeration<AclEntry> enumeration = this.entryList.elements();
        while (enumeration.hasMoreElements()) {
            AclEntryImpl aclEntryImpl = (AclEntryImpl)enumeration.nextElement();
            if (!aclEntryImpl.checkCommunity(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "AclImpl: " + this.getName();
    }
}

