/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Timestamp;
import java.security.cert.X509Certificate;
import java.util.Date;

public class ConstraintsParameters {
    private final String algorithm;
    private final AlgorithmParameters algParams;
    private final Key publicKey;
    private final X509Certificate cert;
    private final boolean trustedMatch;
    private final Date pkixDate;
    private final Timestamp jarTimestamp;
    private final String variant;

    public ConstraintsParameters(X509Certificate x509Certificate, boolean bl, Date date, Timestamp timestamp, String string) {
        this.cert = x509Certificate;
        this.trustedMatch = bl;
        this.pkixDate = date;
        this.jarTimestamp = timestamp;
        this.variant = string == null ? "generic" : string;
        this.algorithm = null;
        this.algParams = null;
        this.publicKey = null;
    }

    public ConstraintsParameters(String string, AlgorithmParameters algorithmParameters, Key key, String string2) {
        this.algorithm = string;
        this.algParams = algorithmParameters;
        this.publicKey = key;
        this.cert = null;
        this.trustedMatch = false;
        this.pkixDate = null;
        this.jarTimestamp = null;
        this.variant = string2 == null ? "generic" : string2;
    }

    public ConstraintsParameters(X509Certificate x509Certificate) {
        this(x509Certificate, false, null, null, "generic");
    }

    public ConstraintsParameters(Timestamp timestamp) {
        this(null, false, null, timestamp, "generic");
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public AlgorithmParameters getAlgParams() {
        return this.algParams;
    }

    public Key getPublicKey() {
        return this.publicKey;
    }

    public boolean isTrustedMatch() {
        return this.trustedMatch;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public Date getPKIXParamDate() {
        return this.pkixDate;
    }

    public Timestamp getJARTimestamp() {
        return this.jarTimestamp;
    }

    public String getVariant() {
        return this.variant;
    }
}

