/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.plugins.wifi101.flashers.java;

import cc.arduino.plugins.wifi101.certs.WiFi101Certificate;
import cc.arduino.plugins.wifi101.certs.WiFi101CertificateBundle;
import cc.arduino.plugins.wifi101.firmwares.WINC1500Firmware;
import cc.arduino.plugins.wifi101.flashers.Flasher;
import cc.arduino.plugins.wifi101.flashers.java.FlasherSerialClient;
import cc.arduino.plugins.wifi101.flashers.java.SSLCertDownloader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;

public abstract class JavaFlasher
implements Flasher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testConnection(String string) throws Exception {
        FlasherSerialClient flasherSerialClient = null;
        try {
            this.progress(50, "Testing programmer...");
            flasherSerialClient = new FlasherSerialClient();
            flasherSerialClient.open(string);
            flasherSerialClient.hello();
            this.progress(100, "Done!");
        }
        finally {
            try {
                if (flasherSerialClient != null) {
                    flasherSerialClient.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFirmware(String string, WINC1500Firmware wINC1500Firmware) throws Exception {
        FlasherSerialClient flasherSerialClient = null;
        try {
            int n;
            this.progress(10, "Connecting to programmer...");
            flasherSerialClient = new FlasherSerialClient();
            flasherSerialClient.open(string);
            flasherSerialClient.hello();
            int n2 = flasherSerialClient.getMaximumPayload();
            byte[] byArray = wINC1500Firmware.getData();
            int n3 = byArray.length;
            int n4 = 0;
            int n5 = 0;
            this.progress(20, "Erasing target...");
            flasherSerialClient.eraseFlash(n4, n3);
            while (n5 < n3) {
                this.progress(20 + n5 * 40 / n3, "Programming " + n3 + " bytes ...");
                n = n2;
                if (n5 + n > n3) {
                    n = n3 - n5;
                }
                flasherSerialClient.writeFlash(n4, Arrays.copyOfRange(byArray, n5, n5 + n));
                n5 += n;
                n4 += n;
            }
            n = 0;
            n4 = 0;
            while (n < n3) {
                byte[] byArray2;
                this.progress(60 + n * 40 / n3, "Verifying...");
                int n6 = n2;
                if (n + n6 > n3) {
                    n6 = n3 - n;
                }
                if (!Arrays.equals(byArray2 = flasherSerialClient.readFlash(n4, n6), Arrays.copyOfRange(byArray, n, n + n6))) {
                    throw new Exception("Error during verify at address " + n4);
                }
                n += n6;
                n4 += n6;
            }
            this.progress(100, "Done!");
        }
        finally {
            try {
                if (flasherSerialClient != null) {
                    flasherSerialClient.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadCertificates(String string, List<String> list) throws Exception {
        FlasherSerialClient flasherSerialClient = null;
        try {
            byte[] byArray;
            this.progress(10, "Connecting to programmer...");
            flasherSerialClient = new FlasherSerialClient();
            flasherSerialClient.open(string);
            flasherSerialClient.hello();
            int n = flasherSerialClient.getMaximumPayload();
            this.progress(20, "Reading section header");
            byte[] byArray2 = flasherSerialClient.readFlash(16384, 16);
            WiFi101CertificateBundle wiFi101CertificateBundle = this.createBundleFromWebsites(list);
            if (Arrays.equals(WiFi101CertificateBundle.START_PATTERN_V0, byArray2)) {
                byArray = wiFi101CertificateBundle.getEncodedV0();
            } else if (Arrays.equals(WiFi101CertificateBundle.START_PATTERN_V1, byArray2)) {
                byArray = wiFi101CertificateBundle.getEncodedV1();
            } else {
                throw new Exception("Unknown starting pattern, please reflash firmware!");
            }
            int n2 = byArray.length;
            int n3 = 16384;
            int n4 = 0;
            this.progress(50, "Erasing target...");
            flasherSerialClient.eraseFlash(n3, n2);
            while (n4 < n2) {
                this.progress(60 + n4 * 80 / n2, "Programming...");
                int n5 = n;
                if (n4 + n5 > n2) {
                    n5 = n2 - n4;
                }
                flasherSerialClient.writeFlash(n3, Arrays.copyOfRange(byArray, n4, n4 + n5));
                n4 += n5;
                n3 += n5;
            }
            this.progress(100, "Done!");
        }
        finally {
            try {
                if (flasherSerialClient != null) {
                    flasherSerialClient.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public WiFi101CertificateBundle createBundleFromWebsites(List<String> list) throws Exception {
        WiFi101CertificateBundle wiFi101CertificateBundle = new WiFi101CertificateBundle();
        int n = 0;
        for (String string : list) {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = new URL("https://" + string);
            }
            this.progress(30 + 20 * n / list.size(), "Downloading certificate from " + string + "...");
            Certificate[] certificateArray = SSLCertDownloader.retrieveFromURL(uRL);
            X509Certificate x509Certificate = (X509Certificate)certificateArray[certificateArray.length - 1];
            WiFi101Certificate wiFi101Certificate = new WiFi101Certificate(x509Certificate);
            wiFi101CertificateBundle.add(wiFi101Certificate);
        }
        return wiFi101CertificateBundle;
    }
}

